/*------------------------------------------------------------------------------*
 * File Name: ReportTreeEx.C		 											*
 * Creation: Iris 2/15/08														*
 * Purpose: OriginC Source C file containing set report tree example.			*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008			*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>

// Run Datasheet_SetReportTree_Ex1 1, will transpose the rows and columns of table
void Datasheet_SetReportTree_Ex1(bool bTransposeTable = false)
{
	int nID = 100; // Each node must have node ID and node ID must be unique except the case described in [Note1] below
	int nTableFormat = GETNBRANCH_OPEN | GETNBRANCH_HIDE_COL_HEADINGS| GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_FIT_COL_WIDTH | GETNBRANCH_FIT_ROW_HEIGHT;
	
	// 1. Create report tree
	Tree tr;
	tr.Report.ID = nID++;
	tr.Report.SetAttribute(STR_LABEL_ATTRIB, "Sample Report Tree"); //Table title
	// TREE_Table attribute is critical in getting the report to work so must be present in every table level. 
	// Can set this attribute as 0 without any format, but many bits GETNBRANCH_* defined in oc_const.h to set table display format.
	tr.Report.SetAttribute(TREE_Table, nTableFormat); 
	
	// 2. Create report table
	tr.Report.Table.ID = nID++;
	tr.Report.Table.SetAttribute(STR_LABEL_ATTRIB, "This is a simple table"); // Table title. If not set this, will show as empty here
	int nSubTableFormat = nTableFormat;
	if(bTransposeTable)
		nSubTableFormat |= GETNBRANCH_TRANSPOSE; // transpose this table
	tr.Report.Table.SetAttribute(TREE_Table, nSubTableFormat); 
	
    // 3 ~ 6 is to add rows and columns to this table. But row and column is not real row and column 
    // since we can transpose table, introduce row and column here in order to easy to understand 
    
	// 3. Add one row to this table
	tr.Report.Table.R1.ID = nID++;
	tr.Report.Table.R1.SetAttribute(STR_LABEL_ATTRIB, "Row 1"); //Row label
	
	// 4. Add two columns to this table
	int nColIDBase = 10000;
	tr.Report.Table.R1.C1.ID = nColIDBase + 1;
	tr.Report.Table.R1.C1.SetAttribute(STR_LABEL_ATTRIB, "Column 1"); // Column label
	tr.Report.Table.R1.C1.dVal = 5;
	
	tr.Report.Table.R1.C2.ID = nColIDBase + 2;
	tr.Report.Table.R1.C2.SetAttribute(STR_LABEL_ATTRIB, "Column 2"); // Column label
	tr.Report.Table.R1.C2.dVal = 10;	
	
	// 5. Add the second row to this table
	tr.Report.Table.R2.ID = nID++;
	tr.Report.Table.R2.SetAttribute(STR_LABEL_ATTRIB, "Row 2"); //Row label
	
	// 6. Fill in values for the two cells in the second row
	tr.Report.Table.R2.C1.ID = nColIDBase + 1; // [Note1] For the same column the differnet row, the node ID should keep same. For example, the ID of node tr.Report.Table.R2.C1 is same as the ID of tr.Report.Table.R1.C1.
	tr.Report.Table.R2.C1.dVal = 15;
	
	tr.Report.Table.R2.C2.ID = nColIDBase + 2;
	tr.Report.Table.R2.C2.dVal = 20;
	
	
	// 7. Prepare worksheet window to report
	WorksheetPage wksPage;
	wksPage.Create();	
	
	DWORD 	dwOptions = WP_SHEET_HIERARCHY | CREATE_NO_DEFAULT_TEMPLATE;		
	string	strSheetName = "Report Sheet";
	int nn = wksPage.AddLayer(strSheetName, dwOptions);
	if( nn < 0 )	
		return;	
	
	Worksheet wksOut = wksPage.Layers(nn);
	wksPage.Layers(0).Delete();	//delete the first default layer	
	
	// 8. Do report
	if( wksOut.SetReportTree(tr.Report) < 0 ) // Returns last row number on successful exit and -1 on failure.
	{
		printf("Fail to set report tree.\n");
		return;
	}		
	wksOut.AutoSize();		
}


void Datasheet_SetReportTree_Ex2()
{
	int nID = 100; // Each node must have node ID and node ID must be unique	
	int nTableFormat = GETNBRANCH_OPEN | GETNBRANCH_HIDE_COL_HEADINGS| GETNBRANCH_HIDE_ROW_HEADINGS | GETNBRANCH_FIT_COL_WIDTH | GETNBRANCH_FIT_ROW_HEIGHT;
	
	// 1. Create report tree
	Tree tr;
	tr.Report.ID = nID++; 
	tr.Report.SetAttribute(STR_LABEL_ATTRIB, "Dest Stats Report"); //Table title
	// TREE_Table attribute is critical in getting the report to work so must be present in every table level. 
	// Can set this attribute as 0 without any format, but many bits GETNBRANCH_* defined in oc_const.h to set table display format.
	tr.Report.SetAttribute(TREE_Table, nTableFormat); 

	
	// 2. Prepare the 1st table Descriptive Statistics and show values got from one structure
	tr.Report.Table1.ID = nID++;
	tr.Report.Table1.SetAttribute(STR_LABEL_ATTRIB, "Descriptive Statistics"); // Table title. If not set this, will show as empty here
	tr.Report.Table1.SetAttribute(TREE_Table, nTableFormat); 
	
	tr.Report.Table1.C1.ID = nID++;
	tr.Report.Table1.C1.SetAttribute(STR_LABEL_ATTRIB, "Result");
	
	tagtTestDescStats stRes; 
	stRes.N = 100;
	stRes.Mean = 604.72;
	stRes.SD = 760.19;
	stRes.SEM = 76.02;	
	
	// Add nodes with values and IDs from structure to tree
	tr.Report.Table1.C1 += stRes;
	
	// !! Please some details of tagtTestDescStats in stats_types.h, already define ID when declaration this structure
	// If stRes is a user defined structure without ID, here need to assign node ID for each child nodes of trCol, for example:
	//foreach(TreeNode trN in tr.Report.Table1.C1.Children)
	//{
		//trN.ID = nID++;
	//}
	
	// Set label for each row
	tr.Report.Table1.C1.N.SetAttribute(STR_LABEL_ATTRIB, "N total");
	tr.Report.Table1.C1.Mean.SetAttribute(STR_LABEL_ATTRIB, "Mean");
	tr.Report.Table1.C1.SD.SetAttribute(STR_LABEL_ATTRIB, "Standard Deviation");
	tr.Report.Table1.C1.SEM.SetAttribute(STR_LABEL_ATTRIB, "SE of Mean");	

	
	// 3. Prepare the 2nd table and show values got from vectors
	tr.Report.Table2.ID = nID++;
	tr.Report.Table2.SetAttribute(STR_LABEL_ATTRIB, "Extreme Values"); //Table tile
	tr.Report.Table2.SetAttribute(TREE_Table, nTableFormat | GETNBRANCH_TRANSPOSE); 
	
	tr.Report.Table2.C1.ID = nID++;
	tr.Report.Table2.C1.SetAttribute(STR_LABEL_ATTRIB, "Max Values"); // Column label
	
	tr.Report.Table2.C2.ID = nID++;
	tr.Report.Table2.C2.SetAttribute(STR_LABEL_ATTRIB, "Min Values"); // Column label		
	
	// Put data from vector to table columns
	vector vMaxDatas = {100, 98, 95, 92, 84};
	vector vMinDatas = {5, 9, 13, 18, 21};
	tr.Report.Table2.C1.dVals = vMaxDatas; 
	tr.Report.Table2.C2.dVals = vMinDatas;	
	
	
	// 4. Prepare worksheet window to report
	WorksheetPage wksPage;
	wksPage.Create();	
	
	DWORD 	dwOptions = WP_SHEET_HIERARCHY | CREATE_NO_DEFAULT_TEMPLATE;		
	string	strSheetName = "Report Sheet";
	int nn = wksPage.AddLayer(strSheetName, dwOptions);
	if( nn < 0 )	
		return;	
	
	Worksheet wksOut = wksPage.Layers(nn);
	wksPage.Layers(0).Delete();	//delete the first default layer	
	
	
	// 5. Do report
	if( wksOut.SetReportTree(tr.Report) < 0 ) // Returns last row number on successful exit and -1 on failure.
	{
		printf("Fail to set report tree.\n");
		return;
	}		
	wksOut.AutoSize();	
}
